/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.engine;

import frc.emul.api.engine.IStatus;
import java.util.ArrayList;
import java.util.List;

public class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;
    private Throwable fThrowable;
    private List<IStatus> childs;
    public static final StatusInfo OK_STATUS = new StatusInfo();

    public static StatusInfo error(String string) {
        return new StatusInfo(4, string);
    }

    public static StatusInfo warn(String string) {
        return new StatusInfo(2, string);
    }

    public static StatusInfo info(String string) {
        return new StatusInfo(1, string);
    }

    public static StatusInfo error(String string, Throwable throwable) {
        return new StatusInfo(4, string, throwable);
    }

    public static StatusInfo warn(String string, Throwable throwable) {
        return new StatusInfo(2, string, throwable);
    }

    public static StatusInfo info(String string, Throwable throwable) {
        return new StatusInfo(1, string, throwable);
    }

    public static StatusInfo promote(IStatus iStatus) {
        return iStatus instanceof StatusInfo ? (StatusInfo)iStatus : new StatusInfo(iStatus);
    }

    public static final String getSeverityText(int n) {
        switch (n) {
            case 8: {
                return "Cancel";
            }
            case 4: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Information";
            }
            case 0: {
                return "OK";
            }
        }
        return "?" + n + "?";
    }

    public static IStatus getMostSevereStatus(IStatus[] iStatusArray) {
        int n = StatusInfo.getMostSevereStatusIndex(iStatusArray);
        return n >= 0 ? iStatusArray[n] : null;
    }

    public static int getMostSevereStatusIndex(IStatus[] iStatusArray) {
        int n;
        int n2 = n = iStatusArray == null ? 0 : iStatusArray.length;
        if (n == 0) {
            return -1;
        }
        IStatus iStatus = iStatusArray[0];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            IStatus iStatus2 = iStatusArray[n4];
            if (iStatus2 != null && (iStatus == null || iStatus2.getSeverity() > iStatus.getSeverity())) {
                iStatus = iStatus2;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public static IStatus getMostSevereStatus(IStatus iStatus, IStatus iStatus2) {
        return iStatus == null ? iStatus2 : (iStatus2 == null ? iStatus : (iStatus.getSeverity() >= iStatus2.getSeverity() ? iStatus : iStatus2));
    }

    public static StatusInfo getMostSevereStatus(StatusInfo statusInfo, StatusInfo statusInfo2) {
        return (StatusInfo)StatusInfo.getMostSevereStatus((IStatus)statusInfo, (IStatus)statusInfo2);
    }

    public static StatusInfo getMostSevereStatus(StatusInfo[] statusInfoArray) {
        return (StatusInfo)StatusInfo.getMostSevereStatus((IStatus[])statusInfoArray);
    }

    public static final boolean isFAULT(IStatus iStatus) {
        return iStatus.getSeverity() >= 4;
    }

    public static final boolean isMEAN(IStatus iStatus) {
        return iStatus.getSeverity() >= 2;
    }

    public static final boolean isVALID(IStatus iStatus) {
        return iStatus.getSeverity() <= 2;
    }

    public static final boolean isMINOR(IStatus iStatus) {
        return iStatus.getSeverity() <= 1;
    }

    public StatusInfo() {
        this(0, null);
    }

    public StatusInfo(IStatus iStatus) {
        this(iStatus, null);
    }

    public StatusInfo(IStatus iStatus, String string) {
        this.fSeverity = iStatus.getSeverity();
        this.fStatusMessage = string == null ? iStatus.getMessage() : String.valueOf(string) + iStatus.getMessage();
    }

    public StatusInfo(int n, String string) {
        this.fStatusMessage = string;
        this.fSeverity = n;
    }

    public StatusInfo(int n, String string, Throwable throwable) {
        this.fStatusMessage = string;
        this.fSeverity = n;
        this.fThrowable = throwable;
    }

    public int compareTo(IStatus iStatus) {
        int n = iStatus.getSeverity();
        int n2 = this.getSeverity();
        return n2 == n ? 0 : (n2 > n ? 1 : -1);
    }

    public boolean isLessSevereThan(IStatus iStatus) {
        return this.getSeverity() < iStatus.getSeverity();
    }

    public boolean isMoreSevereThan(IStatus iStatus) {
        return this.getSeverity() > iStatus.getSeverity();
    }

    public boolean isSameSeverity(IStatus iStatus) {
        return this.getSeverity() == iStatus.getSeverity();
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public boolean isFault() {
        return this.fSeverity >= 4;
    }

    public boolean isMean() {
        return this.fSeverity >= 2;
    }

    public boolean isValid() {
        return this.fSeverity <= 2;
    }

    public boolean isMinor() {
        return this.fSeverity <= 1;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public void setError(String string) {
        this.fStatusMessage = string;
        this.fSeverity = 4;
    }

    public void setError(String string, Throwable throwable) {
        this.setException(throwable);
        this.setError(string);
    }

    public void setWarning(String string) {
        this.fStatusMessage = string;
        this.fSeverity = 2;
    }

    public void setWarning(String string, Throwable throwable) {
        this.setException(throwable);
        this.setWarning(string);
    }

    public void setInfo(String string) {
        this.fStatusMessage = string;
        this.fSeverity = 1;
    }

    public void setInfo(String string, Throwable throwable) {
        this.setException(throwable);
        this.setInfo(string);
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int n) {
        return (this.fSeverity & n) != 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getSeverityText() {
        return StatusInfo.getSeverityText(this.fSeverity);
    }

    public String getPlugin() {
        return null;
    }

    public Throwable getException() {
        return this.fThrowable;
    }

    public void setException(Throwable throwable) {
        this.fThrowable = throwable;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        if (this.childs == null) {
            return new IStatus[0];
        }
        IStatus[] iStatusArray = new IStatus[this.childs.size()];
        this.childs.toArray(iStatusArray);
        return iStatusArray;
    }

    public void addChild(IStatus iStatus) {
        if (this.childs == null) {
            this.childs = new ArrayList<IStatus>();
        }
        this.childs.add(iStatus);
    }

    public boolean isMultiStatus() {
        return this.childs != null;
    }
}

